"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _AuthType = _interopRequireDefault(require("../AuthType"));
var _missing_tenant_error = _interopRequireDefault(require("../../errors/missing_tenant_error"));
var _authentication_error = _interopRequireDefault(require("../../errors/authentication_error"));
var _missing_role_error = _interopRequireDefault(require("../../errors/missing_role_error"));
var _path = _interopRequireDefault(require("path"));
var _AuthManager = require("../../AuthManager");
var _routes = require("./routes");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2018 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

class Saml extends _AuthType.default {
  constructor({
    searchGuardBackend,
    kibanaCore,
    config,
    logger,
    sessionStorageFactory,
    pluginDependencies,
    spacesService
  }) {
    super({
      searchGuardBackend,
      kibanaCore,
      config,
      logger,
      sessionStorageFactory,
      pluginDependencies,
      spacesService
    });

    /**
     * The authType is saved in the auth cookie for later reference
     * @type {string}
     */
    this.type = _AuthManager.AUTH_TYPE_NAMES.SAML;

    /**
     * If a loginURL is defined, we can skip the auth selector page
     * if the customer only has one auth type enabled.
     * @type {string|null}
     */
    this.loginURL = _routes.SAML_ROUTES.LOGIN;
  }
  async getRedirectTargetForUnauthenticated(request, error = null, isAJAX = false) {
    const url = new URL(request.url.href);
    url.pathname = _path.default.posix.join(this.basePath, '/searchguard/login');
    if (error instanceof _missing_tenant_error.default) {
      url.searchParams.set('type', 'missingTenant');
    } else if (error instanceof _missing_role_error.default) {
      url.searchParams.set('type', 'missingRole');
    } else if (error instanceof _authentication_error.default) {
      url.searchParams.set('type', 'authError');
    } else {
      if (!isAJAX) {
        url.searchParams.set('nextUrl', this.getNextUrl(request));
        // Delete sg_tenant because we have it already as a param in the nextUrl
        url.searchParams.delete('sg_tenant');
      }
      url.pathname = _path.default.posix.join(this.basePath, '/auth/saml/login');
    }
    return url.pathname + url.search + url.hash;
  }
  setupRoutes() {
    (0, _routes.defineRoutes)({
      authInstance: this,
      searchGuardBackend: this.searchGuardBackend,
      kibanaCore: this.kibanaCore,
      debugLog: this.debugLog.bind(this),
      sessionStorageFactory: this.sessionStorageFactory,
      logger: this.logger,
      configService: this.config
    });
  }
  async logout({
    context = null,
    request,
    response
  }) {
    // @todo Auth error isn't the best message for this. We still
    // get logged out from Kibana, but the IdP logout may fail.
    let redirectURL = `${this.basePath}/customerror?type=samlAuthError`;
    const sessionCookie = (await this.sessionStorageFactory.asScoped(request).get()) || {};
    const authHeader = this.getAuthHeader(sessionCookie);
    try {
      const sessionInfo = await this.searchGuardBackend.sessionInfo(authHeader);
      redirectURL = sessionInfo.sso_logout_url || this.basePath + '/searchguard/login?type=' + this.type + 'Logout';
    } catch (error) {
      this.logger.error(`SAML auth logout failed while retrieving the sso_logout_url: ${error.stack}`);
    }

    // Clear the cookie credentials
    await this.clear(request, true);
    return response.ok({
      body: {
        authType: this.type,
        redirectURL
      }
    });
  }
}
exports.default = Saml;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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